ORCA/M Asm65816 2.1.0

0001 442B                       title 'QD Pixel Maps        GS ROM 2.0'
0002 442B              ****************************************************************
0003 442B              *                                                              *
0004 442B              *                         Pixel Maps                           *
0005 442B              *                        Version 2.0                           *
0006 442B              *                      December 23, 1986                       *
0007 442B              *                                                              *
0008 442B              *                                                              *
0009 442B              * 2/10/89           Mensch                                     *
0010 442B              * 
0011 442B              * Modified the toslices routine to be able to go fast when we
0012 442B              * are using shadowed memory as well.
0013 442B              *
0014 442B              * 4/6/89            Mensch
0015 442B              * Modified to clear the proper dirty flags.
0016 442B              *
0017 442B              ****************************************************************
0018 442B
0019 442B              ****************************************************************
0020 442B              *                                                              *
0021 442B              *                   Copyright (C) 1985-1987                    *
0022 442B              *                   All Rights Reserved                        *
0023 442B              *                   Apple Computer, Inc.                       *
0024 442B              *                                                              *
0025 442B              ****************************************************************
0026 442B
0027 442B                       blanks off 
0028 442B                       string asis 
0029 442B
0030 442B                       include 'all.macros' 
0031 442B
0032 442B                       include ':QDEquates:qd.data.asm' 
0033 442B
0034 442B                       INCLUDE ':QDEquates:core.globals1' 
0035 442B                       INCLUDE ':QDEquates:core.globals2' 
0036 442B                       INCLUDE ':QDEquates:region.equs' 
0037 442B                       INCLUDE ':QDEquates:slice.equs' 
0038 442B
0039 442B
0040 442B              ;-----------------------------------------------
0041 442B              ;
0042 442B              ;   Imported addresses
0043 442B              ;
0044 442B              ;-----------------------------------------------
0045 442B
0046 442B                       IMPORT BFBICSlice 
0047 442B                       IMPORT BFCopySlice 
0048 442B                       IMPORT BFORSlice 
0049 442B                       IMPORT BFXORSlice 
0050 442B                       IMPORT BusyEC 
0051 442B                       IMPORT BusyErr 
0052 442B                       IMPORT CheckPenVis 
0053 442B                       IMPORT DeRefA 
0054 442B                       IMPORT DeRefB 
0055 442B                       IMPORT DeRefC 
0056 442B                       IMPORT FBICSlice 
0057 442B                       IMPORT FCopySlice 
0058 442B                       IMPORT FORSlice 
0059 442B                       IMPORT FXORSlice 
0060 442B                       IMPORT InitUp3Rgns 
0061 442B                       IMPORT QDStart 
0062 442B                       IMPORT TestGPs 
0063 442B                       IMPORT WideOpen 
0064 442B                       IMPORT bRealFastCopy 
0065 442B                       IMPORT fBFBICSlice 
0066 442B                       IMPORT fBFCopySlice 
0067 442B                       IMPORT fBFORSlice 
0068 442B                       IMPORT fBFXORSlice 
0069 442B                       IMPORT fFBICSlice 
0070 442B                       IMPORT fFCopySlice 
0071 442B                       IMPORT fFORSlice 
0072 442B                       IMPORT fFXORSlice 
0073 442B                       IMPORT fRealFastCopy 
0074 442B
0075 442B              ;-----------------------------------------------
0076 442B              ;
0077 442B              ;   Forward addresses and entries
0078 442B              ;
0079 442B              ;-----------------------------------------------
0080 442B
0081 442B                       ENTRY BackSliceAdrTable 
0082 442B                       ENTRY CallPP 
0083 442B                       ENTRY FastBackSliceAdrTable 
0084 442B                       ENTRY FastSliceAdrTable 
0085 442B                       ENTRY IsDestPort 
0086 442B                       ENTRY RealFastBack 
0087 442B                       ENTRY RealFastForward 
0088 442B                       ENTRY SandDEqual 
0089 442B                       ENTRY SliceAdrTable 
0090 442B
0091 442B
0092 442B              ;                copy pixel.maps/stdpixels
0093 442B              ****************************************************************
0094 442B              *
0095 442B              * StdPixels
0096 442B              *
0097 442B              * Standard pixel painting routine.  Inputs are already on
0098 442B              * zero page as follows when this gets control.
0099 442B              *
0100 442B              *        SrcLocInfo
0101 442B              *        DestLocInfo (this lives in same memory as PortLocInfo)
0102 442B              *        SrcRect
0103 442B              *        DestRect
0104 442B              *        XFerMode
0105 442B              *        RgnHandleA
0106 442B              *        RgnHandleB
0107 442B              *        RgnHandleC (MaskRgn)
0108 442B              *
0109 442B              * Change History
0110 442B              *
0111 442B              * June ?, 1986      This routine did not handle source and
0112 442B              *                   destination pixel maps crossing bank boundries
0113 442B              *                   until now.
0114 442B              * August 8, 1986    When the src and dest pixel maps were not equal
0115 442B              *                   chunkiness, the bank reg was left on stack and
0116 442B              *                   system crashed.
0117 442B              *
0118 442B              * November 18, 1986 It now handles stretching. oh my.
0119 442B              *
0120 442B              * March 11, 1987    If pen is not visible, I don't return error
0121 442B              *                   in a-reg any more.
0122 442B              *
0123 442B              ****************************************************************
0124 442B                       EXPORT iStdPixels 
0125 442B              iStdPixels PROC 
0126 442B              *              using CoreDATA
0127 442B              *              using E0Vectors
0128 442B              *              using PicInfo
0129 442B              *              using ErrorDATA
0130 442B
0131 442B              ;-------------------------------------------------
0132 442B              ;
0133 442B              ; If the dest loc is the same as the current
0134 442B              ; graf port, then we check if a picture is being
0135 442B              ; captured.
0136 442B              ;
0137 442B 20 F9 4A              jsr   IsDestPort
0138 442E 90 0A                 bcc   SkipPicture
0139 4430
0140 4430 A9 90 00              lda   #MapNoun
0141 4433 22 F8 1E E0           jsl   PutPictStuff
0142 4437 90 01                 bcc   NoPicErr
0143 4439 6B                    rtl   
0144 443A
0145 443A              NoPicErr                                ; 
0146 443A 20 17 34     SkipPicture jsr   CheckPenVis           ; does not come back if not vis
0147 443D 5C DC 1F E0           jml   RgnBlt
0148 4441
0149 4441                       ENDP 
0150 4441              ;                copy pixel.maps/rgnblt
0151 4441              ****************************************************************
0152 4441              *
0153 4441              * RgnBlt
0154 4441              *
0155 4441              * This was the original StdPixel (back before stretching was
0156 4441              * invented [or rediscovered]).
0157 4441              *
0158 4441              * Modification History:
0159 4441              * 12/1/87      GCP     Moved calls to setup routines. They're now
0160 4441              *                      made after we decide which direction we are
0161 4441              *                      going. When we want to seek up through the
0162 4441              *                      region we now call InitUp3Rgns.
0163 4441              ****************************************************************
0164 4441                       EXPORT iRgnBlt 
0165 4441              iRgnBlt  PROC 
0166 4441              *              using CoreDATA
0167 4441              *              using E0Vectors
0168 4441              *              using PicInfo
0169 4441              *              using ErrorDATA
0170 4441
0171 4441
0172 4441 8B                    phb   
0173 4442
0174 4442              ;-----------------------------------------------
0175 4442              ;
0176 4442              ; Are we transfering to and from pixel maps of
0177 4442              ; the same chunkiness?
0178 4442              ;
0179 4442 A5 CC                 lda   SrcSCB
0180 4444 45 0C                 eor   DestSCB
0181 4446 29 80 00              and   #%0000000010000000
0182 4449 F0 06                 beq   SameChunk
0183 444B
0184 444B A9 20 04              lda   #NotEqualChunkiness
0185 444E 4C 1C 46              jmp   ReportError
0186 4451
0187 4451              ;-----------------------------------------------
0188 4451              ;
0189 4451              ; Now we run through lots of code to set up all
0190 4451              ; variables required by the slice routines.
0191 4451              ;
0192 4451              SameChunk                               ; 
0193 4451
0194 4451              ;----------------------------------------------
0195 4451              ;
0196 4451              ; First, we clip the Source Rect to the Source
0197 4451              ; Bounds Rect.  If it is not inside, we are
0198 4451              ; done.  At the same time, we adjust the destination
0199 4451              ; point by any amount that we clip the upper left
0200 4451              ; of the source rect.
0201 4451              ;
0202 4451 A5 D4                 lda   SrcBounds
0203 4453 C5 DC                 cmp   SrcRect
0204 4455 30 0C                 bmi   TopOK1
0205 4457 38                    sec                            ; first i calculate SrcBoundsTop - SrcTop
0206 4458 E5 DC                 sbc   SrcRect                  ; we know this is a num < 0
0207 445A 18                    clc                            ; I then add it to DestPoint
0208 445B 65 1C                 adc   DestPoint
0209 445D 85 1C                 sta   DestPoint
0210 445F A5 D4                 lda   SrcBounds
0211 4461 85 DC                 sta   SrcRect
0212 4463 A5 D6        TopOk1   lda   SrcBounds+2
0213 4465 C5 DE                 cmp   SrcRect+2
0214 4467 30 0C                 bmi   LeftOK1
0215 4469 38                    sec                            ; now i calculate SrcBoundsLeft-SrcLeft
0216 446A E5 DE                 sbc   SrcRect+2                ; we know this is a num < 0
0217 446C 18                    clc                            ; I then add it to DestPoint
0218 446D 65 1E                 adc   DestPoint+2
0219 446F 85 1E                 sta   DestPoint+2
0220 4471 A5 D6                 lda   SrcBounds+2
0221 4473 85 DE                 sta   SrcRect+2
0222 4475 A5 D8        LeftOK1  lda   SrcBounds+4
0223 4477 C5 E0                 cmp   SrcRect+4
0224 4479 10 02                 bpl   BottomOK1
0225 447B 85 E0                 sta   SrcRect+4
0226 447D A5 DA        BottomOK1 lda   SrcBounds+6
0227 447F C5 E2                 cmp   SrcRect+6
0228 4481 10 02                 bpl   RightOK1
0229 4483 85 E2                 sta   SrcRect+6
0230 4485 A5 DC        RightOK1 lda   SrcRect
0231 4487 C5 E0                 cmp   SrcRect+4
0232 4489 30 03                 bmi   VValid1
0233 448B 4C 16 46              jmp   NeverMind                ; rect not valid, Top > Bottom
0234 448E A5 DE        VValid1  lda   SrcRect+2
0235 4490 C5 E2                 cmp   SrcRect+6
0236 4492 30 03                 bmi   HValid1
0237 4494 4C 16 46              jmp   NeverMind                ; Rect not valid, Left > Right
0238 4497              HValid1                                 ; 
0239 4497
0240 4497
0241 4497              ;-------------------------------------------
0242 4497              ;
0243 4497              ; Now we stretch the dest point into a
0244 4497              ; rectangle of the same size as the clipped
0245 4497              ; source rectangle.
0246 4497              ;
0247 4497 A2 02 00              ldx   #2
0248 449A B5 E0        DestRectLoop lda   SrcRect+4,x          ; calculate size
0249 449C 38                    sec   
0250 449D F5 DC                 sbc   SrcRect,x
0251 449F 18                    clc                            ; add to point
0252 44A0 75 1C                 adc   DestPoint,x
0253 44A2 95 20                 sta   DestPoint+4,x
0254 44A4 CA                    dex   
0255 44A5 CA                    dex   
0256 44A6 10 F2                 bpl   DestRectLoop
0257 44A8
0258 44A8 22 E0 1F E0           jsl   SharedMRSetup            ; calls make minrect
0259 44AC
0260 44AC 90 03                 bcc   SomethingLeft
0261 44AE 4C 12 46              jmp   AllDone
0262 44B1
0263 44B1              SomethingLeft                           ; 
0264 44B1
0265 44B1              ;-----------------------------------------------
0266 44B1              ;
0267 44B1              ; Now I check to see if the dest rect got 
0268 44B1              ; clipped.  If it did get clipped, then I must
0269 44B1              ; adjust the source rect accordingly.
0270 44B1 A2 06 00              ldx   #6
0271 44B4              AdjSrcLoop                              ; 
0272 44B4 B5 00                 lda   MinRect,x                ; I subtract DestRect from MinRect
0273 44B6 38                    sec                            ; If not clipped on that side result
0274 44B7 F5 1C                 sbc   DestRect,x               ; is zero.  If clipped at top or left,
0275 44B9 F0 05                 beq   SideStillOK              ; then result is positive and so is
0276 44BB 18                    clc                            ; amount src must be adjusted.  If
0277 44BC 75 DC                 adc   SrcRect,x                ; clipped at bot or right, then result
0278 44BE 95 DC                 sta   SrcRect,x                ; is negative and so is amount src 
0279 44C0 CA           SideStillOK dex                         ; must be adjusted.
0280 44C1 CA                    dex   
0281 44C2 10 F0                 bpl   AdjSrcLoop
0282 44C4
0283 44C4              *			; move clipped value of destrect
0284 44C4              *			; back to DestRect
0285 44C4 A5 00 85 1C           MoveRect MinRect,DestRect 
0286 44D4
0287 44D4 22 E4 1F E0           jsl   ShareShieldStuff
0288 44D8
0289 44D8
0290 44D8 22 98 1E E0  NotSame  jsl   ShieldCursor             ; use minrect to shield cursor
0291 44DC
0292 44DC              *			; move orig clip rect back to dest
0293 44DC              *			; so that rgn clipping can work!
0294 44DC A5 1C 85 00           MoveRect DestRect,MinRect 
0295 44EC
0296 44EC              ;-------------------------------------------------
0297 44EC              ;
0298 44EC              ; Source and dest Rects are entirely contained
0299 44EC              ; in the bounds rects.
0300 44EC              ;
0301 44EC              ; Figure out if we are painting in and out of
0302 44EC              ; the same pixel map.
0303 44EC              ;
0304 44EC A2 00 00              ldx   #0                       ; use x and y as flags for
0305 44EF 9B                    txy                            ; backwards and forwards
0306 44F0
0307 44F0 20 1F 46              jsr   SandDEqual
0308 44F3 90 24                 bcc   DifferentMaps
0309 44F5
0310 44F5
0311 44F5              ;-------------------------------------------------
0312 44F5              ;
0313 44F5              ; The maps are the same.
0314 44F5              ;
0315 44F5 A5 1C                 lda   DestPoint                ; convert dest y to global coord's
0316 44F7 38                    sec                            ; and push it on the stack
0317 44F8 E5 14                 sbc   DestBounds
0318 44FA 48                    pha   
0319 44FB A5 DC                 lda   SrcRect                  ; convert src y to global coord's
0320 44FD 38                    sec                            ; and compare it to value on stack
0321 44FE E5 D4                 sbc   SrcBounds
0322 4500 C3 01                 cmp   1,s
0323 4502 B0 03                 bcs   VertIsForward
0324 4504 88                    dey   
0325 4505 80 11                 bra   HorIsForward             ; if vert is backwards then hor can
0326 4507
0327 4507 A5 1E        VertIsForward lda   DestPoint+2         ; Convert DestX to global and replace
0328 4509 38                    sec                            ; global y value on stack
0329 450A E5 16                 sbc   DestBounds+2
0330 450C 83 01                 sta   1,s
0331 450E A5 DE                 lda   SrcRect+2                ; convert SrcX to global and compare
0332 4510 38                    sec                            ; to value on stack
0333 4511 E5 16                 sbc   DestBounds+2
0334 4513 C3 01                 cmp   1,s
0335 4515 B0 01                 bcs   HorIsForward
0336 4517 CA                    dex   
0337 4518 68           HorIsForward pla                        ; clear the stack
0338 4519 84 C8        DifferentMaps sty   VertBackward
0339 451B 86 CA                 stx   HorBackward
0340 451D
0341 451D              ;-------------------------------------------------
0342 451D              ;
0343 451D              ; Set up the SrcRef and DestRef pointers.
0344 451D              ;
0345 451D F4 00 00              pea   0                        ; put room for result on stack
0346 4520 F4 00 00              pea   0
0347 4523 C0 00 00              cpy   #0                       ; if y is still pos then we go
0348 4526 10 05                 bpl   UseSrcTop                ; from top to bottom
0349 4528 A5 E0                 lda   SrcRect+4                ; get bottom minus one in a reg
0350 452A 3A                    dec   a
0351 452B 80 02                 bra   PushStart1
0352 452D A5 DC        UseSrcTop lda   SrcRect                 ; get top in a-reg
0353 452F 38           PushStart1 sec                          ; convert to global coord's
0354 4530 E5 D4                 sbc   SrcBounds
0355 4532 48                    pha                            ; push it
0356 4533 D4 D2                 pei   SrcWidth
0357 4535 A2 0B 09 22           _Multiply 
0358 453C
0359 453C 68                    pla   
0360 453D FA                    plx   
0361 453E 18                    clc   
0362 453F 65 CE                 adc   SrcPixelMapRef
0363 4541 85 B2                 sta   SrcRef
0364 4543 8A                    txa   
0365 4544 65 D0                 adc   SrcPixelMapRef+2
0366 4546 85 B4                 sta   SrcRef+2
0367 4548
0368 4548 F4 00 00              pea   0                        ; put room for result on stack
0369 454B F4 00 00              pea   0
0370 454E 24 C8                 bit   VertBackward
0371 4550 10 05                 bpl   UseDestTop
0372 4552 A5 20                 lda   DestRect+4
0373 4554 3A                    dec   a
0374 4555 80 02                 bra   PushStart2
0375 4557 A5 1C        UseDestTop lda   DestRect
0376 4559 38           PushStart2 sec   
0377 455A E5 14                 sbc   DestBounds
0378 455C 48                    pha   
0379 455D D4 12                 pei   DestWidth
0380 455F A2 0B 09 22           _Multiply 
0381 4566 68                    pla   
0382 4567 FA                    plx   
0383 4568 18                    clc   
0384 4569 65 0E                 adc   DestPixelMapRef
0385 456B 85 BE                 sta   DestRef
0386 456D 8A                    txa   
0387 456E 65 10                 adc   DestPixelMapRef+2
0388 4570 85 C0                 sta   DestRef+2
0389 4572
0390 4572              ;-------------------------------------------------
0391 4572              ;
0392 4572              ; Set up looping vars, clipping and the address
0393 4572              ; of the slice routine to be used.
0394 4572              ;
0395 4572
0396 4572
0397 4572 D4 BF                 pei   DestRef+1                ; set the data bank register to
0398 4574 AB                    plb                            ; bank containing dest map
0399 4575 AB                    plb   
0400 4576
0401 4576 B8                    clv   
0402 4577 A5 E4                 lda   XFerMode
0403 4579 10 02                 bpl   NotInverted
0404 457B E2 40                 sep   #%01000000               ; set the overflow
0405 457D 08           NotInverted php                         ; save this on stack
0406 457E
0407 457E A5 20                 lda   DestRect+4               ; assume we go backwards
0408 4580 3A                    dec   a
0409 4581 85 40                 sta   CurrentY
0410 4583
0411 4583 24 C8                 bit   VertBackward
0412 4585 30 45                 bmi   BackLp
0413 4587
0414 4587 A5 1C                 lda   DestRect                 ; bad guess, we go forewards
0415 4589 85 40                 sta   CurrentY
0416 458B
0417 458B 22 7C 1E E0           jsl   SliceSetup
0418 458F 22 A4 1E E0           jsl   SetUpScanPtrs
0419 4593 22 C4 1E E0           jsl   Init3Regions
0420 4597 22 EC 1E E0           jsl   SetSliceAdr
0421 459B
0422 459B              PaintLoop                               ; 
0423 459B 22 D0 1E E0           jsl   Seek3Regions
0424 459F
0425 459F 28                    plp                            ; get v flag back
0426 45A0 08                    php                            ; save for later too
0427 45A1
0428 45A1 22 00 1E E0           jsl   ToSlice
0429 45A5
0430 45A5 A5 40                 lda   CurrentY
0431 45A7 1A                    inc   a
0432 45A8 C5 20                 cmp   DestRect+4
0433 45AA 10 61                 bpl   TheEnd                   ; unsigned compare dummy 28 Mar 86
0434 45AC
0435 45AC 85 40                 sta   CurrentY
0436 45AE A5 D2                 lda   SrcWidth
0437 45B0 18                    clc   
0438 45B1 65 B2                 adc   SrcRef
0439 45B3 85 B2                 sta   SrcRef
0440 45B5 90 02                 bcc   NoCarrySrc               ; must carry accross banks
0441 45B7 E6 B4                 inc   SrcRef+2
0442 45B9 A5 12        NoCarrySrc lda   DestWidth
0443 45BB 18                    clc   
0444 45BC 65 BE                 adc   DestRef
0445 45BE 85 BE                 sta   DestRef
0446 45C0 90 08                 bcc   NoCarryDest
0447 45C2 E6 C0                 inc   DestRef+2
0448 45C4 8B                    phb                            ; must also update the data bank
0449 45C5 A5 BF                 lda   DestRef+1                ; register
0450 45C7 83 00                 sta   0,s
0451 45C9 AB                    plb   
0452 45CA              NoCarryDest                             ; 
0453 45CA
0454 45CA 80 CF                 bra   PaintLoop
0455 45CC
0456 45CC              BackLp                                  ; 
0457 45CC 22 7C 1E E0           jsl   SliceSetup
0458 45D0 22 A4 1E E0           jsl   SetUpScanPtrs
0459 45D4 22 C6 5C FE           jsl   InitUp3Rgns
0460 45D8 22 EC 1E E0           jsl   SetSliceAdr
0461 45DC
0462 45DC              BackLoop                                ; 
0463 45DC 22 D0 1E E0           jsl   Seek3Regions             ; this will be very slow 
0464 45E0              *			; because seekrgn is optimized 
0465 45E0              *			; for forward.
0466 45E0
0467 45E0 28                    plp                            ; get v flag back
0468 45E1 08                    php                            ; save for later too
0469 45E2
0470 45E2 22 00 1E E0           jsl   ToSlice
0471 45E6
0472 45E6              BackHere2                               ; 
0473 45E6
0474 45E6 A5 40                 lda   CurrentY
0475 45E8 3A                    dec   a
0476 45E9 C5 1C                 cmp   DestRect
0477 45EB 30 20                 bmi   TheEnd
0478 45ED
0479 45ED 85 40                 sta   CurrentY
0480 45EF A5 B2                 lda   SrcRef
0481 45F1 38                    sec   
0482 45F2 E5 D2                 sbc   SrcWidth
0483 45F4 85 B2                 sta   SrcRef
0484 45F6 B0 02                 bcs   NoBorrowSrc              ; must borrow from high word
0485 45F8 C6 B4                 dec   SrcRef+2                 ; if crosses bank
0486 45FA A5 BE        NoBorrowSrc lda   DestRef
0487 45FC 38                    sec   
0488 45FD E5 12                 sbc   DestWidth
0489 45FF 85 BE                 sta   DestRef
0490 4601 B0 08                 bcs   NoBorrowDest
0491 4603 C6 C0                 dec   DestRef+2
0492 4605 8B                    phb                            ; must also update the data bank
0493 4606 A5 BF                 lda   DestRef+1                ; register
0494 4608 83 00                 sta   0,s
0495 460A AB                    plb   
0496 460B              NoBorrowDest                            ; 
0497 460B
0498 460B 80 CF                 bra   BackLoop
0499 460D
0500 460D
0501 460D 22 9C 1E E0  TheEnd   jsl   UnShieldCursor
0502 4611
0503 4611 28                    plp                            ; clean up stack
0504 4612
0505 4612 22 B4 1E E0  AllDone  jsl   Free3Regions
0506 4616
0507 4616 AB           NeverMind plb   
0508 4617
0509 4617
0510 4617
0511 4617 A9 00 00              lda   #0
0512 461A 18                    clc   
0513 461B 6B                    rtl   
0514 461C
0515 461C AB           ReportError plb                         ; added restore b here SEG 8 Aug 86
0516 461D 38                    sec   
0517 461E 6B                    rtl   
0518 461F
0519 461F
0520 461F              ;----------------------------------------------------
0521 461F              ;
0522 461F              ; Local routine to determine if the source and dest
0523 461F              ; are equal.
0524 461F              ;
0525 461F                       EXPORT SandDEqual 
0526 461F              SandDEqual                              ; 
0527 461F A5 CE                 lda   SrcPixelMapRef           ; are we painting in and
0528 4621 C5 0E                 cmp   DestPixelMapRef          ; out of same pixel map?
0529 4623 D0 08                 bne   DM
0530 4625 A5 CF                 lda   SrcPixelMapRef+1
0531 4627 C5 0F                 cmp   DestPixelMapRef+1
0532 4629 D0 02                 bne   DM
0533 462B 38                    sec   
0534 462C 60                    rts   
0535 462D 18           DM       clc   
0536 462E 60                    rts   
0537 462F
0538 462F
0539 462F                       ENDP 
0540 462F
0541 462F
0542 462F
0543 462F
0544 462F
0545 462F              ****************************************************************
0546 462F              *
0547 462F              * SharedMRSetup
0548 462F              *
0549 462F              * This is code shared by rgnblt and stetch to setup the
0550 462F              * minrect and to clip the destrect to the bounds rect of
0551 462F              * rgn C.
0552 462F              *
0553 462F              * At the very end this routine calls makeMinRect and then
0554 462F              * returns with the same condition codes set.
0555 462F              *
0556 462F              ****************************************************************
0557 462F                       EXPORT iSharedMRSetup 
0558 462F              iSharedMRSetup PROC 
0559 462F              *              using E0Vectors
0560 462F              *              using CoreData
0561 462F              ;-------------------------------------------
0562 462F              ;
0563 462F              ; Now we have to clip the dest rect to the
0564 462F              ; dest bounds rect and the clipping region
0565 462F              ; bounding box.
0566 462F              ;
0567 462F 20 7D 5A              jsr   DeRefA
0568 4632 20 9E 5A              jsr   DeRefB
0569 4635
0570 4635 20 BF 5A              jsr   DeRefC                   ; we do C too now and then
0571 4638
0572 4638
0573 4638 A0 02 00              ldy   #2
0574 463B B7 74                 lda   [RgnPtrC],y              ; we intersect DestRect and Bounds
0575 463D C5 1C                 cmp   DestRect                 ; of rgn c
0576 463F 10 02                 bpl   RgnTopBigger
0577 4641 A5 1C                 lda   DestRect
0578 4643 85 00        RgnTopBigger sta   MinRect
0579 4645 C8                    iny   
0580 4646 C8                    iny   
0581 4647 B7 74                 lda   [RgnPtrC],y
0582 4649 C5 1E                 cmp   DestRect+2
0583 464B 10 02                 bpl   RgnLeftBigger
0584 464D A5 1E                 lda   DestRect+2
0585 464F 85 02        RgnLeftBigger sta   MinRect+2
0586 4651 C8                    iny   
0587 4652 C8                    iny   
0588 4653 B7 74                 lda   [RgnPtrC],y
0589 4655 C5 20                 cmp   DestRect+4
0590 4657 30 02                 bmi   RgnBotSmaller
0591 4659 A5 20                 lda   DestRect+4
0592 465B 85 04        RgnBotSmaller sta   MinRect+4
0593 465D C8                    iny   
0594 465E C8                    iny   
0595 465F B7 74                 lda   [RgnPtrC],y
0596 4661 C5 22                 cmp   DestRect+6
0597 4663 30 02                 bmi   RgnRightSmaller
0598 4665 A5 22                 lda   DestRect+6
0599 4667 85 06        RgnRightSmaller sta   MinRect+6
0600 4669
0601 4669              ;----------------------------------------------------------
0602 4669              ;
0603 4669              ; Now the intersection of the dest rect and the bounds of
0604 4669              ; rgn c are in MinRect.
0605 4669              ;
0606 4669 24 E6                 bit   ClipToPortToo
0607 466B 10 2E                 bpl   SkipPortRect
0608 466D
0609 466D 20 F9 4A              jsr   IsDestPort
0610 4670 90 29                 bcc   SkipPortRect
0611 4672
0612 4672 A0 10 00              ldy   #o_PortRect
0613 4675 B7 24                 lda   [PortRef],y
0614 4677 C5 00                 cmp   MinRect
0615 4679 30 02                 bmi   MinTopOK
0616 467B 85 00                 sta   MinRect
0617 467D C8           MinTopOK iny   
0618 467E C8                    iny   
0619 467F B7 24                 lda   [PortRef],y
0620 4681 C5 02                 cmp   MinRect+2
0621 4683 30 02                 bmi   MinLeftOK
0622 4685 85 02                 sta   MinRect+2
0623 4687 C8           MinLeftOK iny   
0624 4688 C8                    iny   
0625 4689 B7 24                 lda   [PortRef],y
0626 468B C5 04                 cmp   MinRect+4
0627 468D 10 02                 bpl   MinBotOK
0628 468F 85 04                 sta   MinRect+4
0629 4691 C8           MinBotOK iny   
0630 4692 C8                    iny   
0631 4693 B7 24                 lda   [PortRef],y
0632 4695 C5 06                 cmp   MinRect+6
0633 4697 10 02                 bpl   MinRightOK
0634 4699 85 06                 sta   MinRect+6
0635 469B              MinRightOK                              ; 
0636 469B
0637 469B
0638 469B
0639 469B              SkipPortRect                            ; 
0640 469B
0641 469B 22 94 1E E0           jsl   MakeMinRect
0642 469F
0643 469F 6B                    rtl   
0644 46A0
0645 46A0                       ENDP 
0646 46A0
0647 46A0
0648 46A0              ****************************************************************
0649 46A0              *
0650 46A0              * ShareShieldStuff
0651 46A0              *
0652 46A0              * If the source and dest pixel maps are the same,
0653 46A0              * then the minrect needs be enlarged to the union
0654 46A0              * of the src and dest rects.
0655 46A0              *
0656 46A0              * Warning!!!
0657 46A0              *
0658 46A0              * This is not enough.  If the source is the screen and
0659 46A0              * the dest is not, we still want to shield the cursor
0660 46A0              * accordingly.  I don't know how to handle this yet.
0661 46A0              *
0662 46A0              ****************************************************************
0663 46A0                       EXPORT iShareShieldStuff 
0664 46A0              iShareShieldStuff PROC 
0665 46A0
0666 46A0 20 1F 46              jsr   SandDEqual
0667 46A3 90 28                 bcc   NotSame
0668 46A5
0669 46A5 A5 1C                 lda   DestRect
0670 46A7 C5 DC                 cmp   SrcRect
0671 46A9 30 02                 bmi   UseDest1
0672 46AB A5 DC                 lda   SrcRect
0673 46AD 85 00        UseDest1 sta   MinRect
0674 46AF A5 1E                 lda   DestRect+2
0675 46B1 C5 DE                 cmp   SrcRect+2
0676 46B3 30 02                 bmi   UseDest2
0677 46B5 A5 DE                 lda   srcRect+2
0678 46B7 85 02        UseDest2 sta   MinRect+2
0679 46B9 A5 20                 lda   DestRect+4
0680 46BB C5 E0                 cmp   SrcRect+4
0681 46BD 10 02                 bpl   UseDest3
0682 46BF A5 E0                 lda   SrcRect+4
0683 46C1 85 04        UseDest3 sta   MinRect+4
0684 46C3 A5 22                 lda   DestRect+6
0685 46C5 C5 E2                 cmp   SrcRect+6
0686 46C7 10 02                 bpl   UseDest4
0687 46C9 A5 E2                 lda   SrcRect+6
0688 46CB 85 06        UseDest4 sta   MinRect+6
0689 46CD
0690 46CD
0691 46CD 6B           NotSame  rtl   
0692 46CE
0693 46CE                       ENDP 
0694 46CE
0695 46CE              ;                copy pixel.maps/pp.to.port
0696 46CE              ****************************************************************
0697 46CE              *
0698 46CE              * Revision History
0699 46CE              *
0700 46CE              * 6 Oct 1986   SEG     Changed all the entry points so that
0701 46CE              *                      they call QDStart.  This does the right
0702 46CE              *                      thing with the direct page and incs
0703 46CE              *                      the busy flag.  Original code did not
0704 46CE              *                      inc the busy flag.
0705 46CE              *
0706 46CE              ****************************************************************
0707 46CE
0708 46CE
0709 46CE
0710 46CE
0711 46CE
0712 46CE
0713 46CE
0714 46CE
0715 46CE
0716 46CE              ****************************************************************
0717 46CE              *
0718 46CE              * PPToPort
0719 46CE              *
0720 46CE              *     PtrToSourceLocInfo                ; 4
0721 46CE              *     PtrToSourceRect                   ; 8
0722 46CE              *     DestX                             ; 10
0723 46CE              *     DestY                             ; 12
0724 46CE              *     Mode                              ; 14
0725 46CE              *
0726 46CE              *
0727 46CE              * The LocInfo Record Looks Like
0728 46CE              *
0729 46CE              *     MasterSCB         byte
0730 46CE              *     Reserved          byte
0731 46CE              *     PtrToPixelMap     long
0732 46CE              *     Width             word
0733 46CE              *     BoundsRect        rect
0734 46CE              *
0735 46CE              ****************************************************************
0736 46CE                       EXPORT PPToPort 
0737 46CE              PPToPort PROC 
0738 46CE              *              using CoreData
0739 46CE              *              using E0Vectors
0740 46CE
0741 46CE              OrigDirect equ   1
0742 46CE              RTL1     equ   OrigDirect+2
0743 46CE              RTL2     equ   RTL1+3
0744 46CE              PPMode   equ   RTL2+3
0745 46CE              PPDestY  equ   PPMode+2
0746 46CE              PPDestX  equ   PPDestY+2
0747 46CE              PPSrcRect equ   PPDestX+2
0748 46CE              PPLocInfo equ   PPSrcRect+4
0749 46CE
0750 46CE
0751 46CE              ;------------------------------------------------------
0752 46CE              ;
0753 46CE              ; Setup zp
0754 46CE              ;
0755 46CE 20 AA 0F              jsr   QDStart
0756 46D1
0757 46D1              ;------------------------------------------------------
0758 46D1              ;
0759 46D1              ; Read the source loc info from user to zp.
0760 46D1              ;
0761 46D1 A3 13                 lda   PPLocInfo,s
0762 46D3 85 2E                 sta   Temp2
0763 46D5 A3 15                 lda   PPLocInfo+2,s
0764 46D7 85 30                 sta   Temp2+2
0765 46D9
0766 46D9 A0 0E 00              ldy   #LocSize-2               ; move srclocinfo to zp
0767 46DC BB           Loop1    tyx   
0768 46DD B7 2E                 lda   [Temp2],y
0769 46DF 95 CC                 sta   SrcSCB,x
0770 46E1 88                    dey   
0771 46E2 88                    dey   
0772 46E3 10 F7                 bpl   Loop1
0773 46E5
0774 46E5              ;------------------------------------------------------
0775 46E5              ;
0776 46E5              ; The dest loc info is from the current graf port.
0777 46E5
0778 46E5 22 3C 1E E0           jsl   PortLoc2ZP               ; move dest info to zp
0779 46E9
0780 46E9              ;------------------------------------------------------
0781 46E9              ;
0782 46E9              ; Read source rect from memory to zp.
0783 46E9              ;
0784 46E9 A3 0F                 lda   PPSrcRect,s
0785 46EB 85 2E                 sta   temp2
0786 46ED A3 11                 lda   PPSrcRect+2,s
0787 46EF 85 30                 sta   temp2+2
0788 46F1
0789 46F1 A0 06 00              ldy   #6
0790 46F4 BB           Loop3    tyx   
0791 46F5 B7 2E                 lda   [Temp2],y
0792 46F7 95 DC                 sta   SrcRect,x
0793 46F9 88                    dey   
0794 46FA 88                    dey   
0795 46FB 10 F7                 bpl   Loop3
0796 46FD
0797 46FD              ;------------------------------------------------------
0798 46FD              ;
0799 46FD              ; Get dest point off stack onto zp.
0800 46FD              ;
0801 46FD A3 0B                 lda   PPDestY,s
0802 46FF 85 1C                 sta   DestPoint
0803 4701 A3 0D                 lda   PPDestX,s
0804 4703 85 1E                 sta   DestPoint+2
0805 4705
0806 4705
0807 4705              ;----------------------------------------------------
0808 4705              ;
0809 4705              ; Extend the destpoint into a rectangle of the same
0810 4705              ; size.
0811 4705              ;
0812 4705 A5 E0                 lda   SrcRect+4
0813 4707 38                    sec   
0814 4708 E5 DC                 sbc   SrcRect
0815 470A 18                    clc   
0816 470B 65 1C                 adc   DestPoint
0817 470D 85 20                 sta   DestPoint+4
0818 470F
0819 470F A5 E2                 lda   SrcRect+6
0820 4711 38                    sec   
0821 4712 E5 DE                 sbc   SrcRect+2
0822 4714 18                    clc   
0823 4715 65 1E                 adc   DestPoint+2
0824 4717 85 22                 sta   DestPoint+6
0825 4719
0826 4719
0827 4719              ;------------------------------------------------------
0828 4719              ;
0829 4719              ; Get transfer mode from stack to zero page.
0830 4719              ;
0831 4719 A3 09                 lda   PPMode,s
0832 471B 85 E4                 sta   XFerMode
0833 471D
0834 471D              ;------------------------------------------------------
0835 471D              ;
0836 471D              ; Bring clip and vis rgn to zero page.
0837 471D              ;
0838 471D
0839 471D 22 A0 1E E0           jsl   SetUpPortRegions
0840 4721
0841 4721 A9 0C 10              lda   #WideOpen                ; put fake region in here
0842 4724 85 70                 sta   RgnHandleC
0843 4726 A9 FE 00              lda   #^WideOpen
0844 4729 85 72                 sta   RgnHandleC+2
0845 472B
0846 472B              ;----------------------------------------------------------
0847 472B              ;
0848 472B              ; Set flag to indicate that we need to clip to port rect
0849 472B              ;
0850 472B A9 00 80              lda   #$8000
0851 472E 85 E6                 sta   ClipToPortToo
0852 4730
0853 4730              ;------------------------------------------------------
0854 4730              ;
0855 4730              ; Call standard pixels.
0856 4730              ;
0857 4730 22 DE 4A FE           jsl   CallPP                   ; error comes back in a
0858 4734 48                    pha                            ; save the error
0859 4735 A2 00 02 B5           DirtyPort                      ; reset the port dirty flags
0860 473F 68                    pla                            ; and restore the port
0861 4740              ;------------------------------------------------------
0862 4740              ;
0863 4740              ; Error returned in a reg.
0864 4740              ;
0865 4740 AA                    tax   
0866 4741 A0 0E 00              ldy   #14
0867 4744 4C AA FC              jmp   BusyErr
0868 4747
0869 4747                       ENDP 
0870 4747              ;                copy pixel.maps/scroll.rect
0871 4747              ****************************************************************
0872 4747              *
0873 4747              * ScrollRect    (TheRect : rect; 
0874 4747              *                dh, dv : integer; 
0875 4747              *                UpdateRgn : handle);
0876 4747              *
0877 4747              *
0878 4747              *
0879 4747              *
0880 4747              * The Flow of control
0881 4747              *
0882 4747              *     1.  I bring the portlocinfo to zero page as the SrcLocInfo
0883 4747              *         and the DestLocInfo.  This includes the PortRect as the
0884 4747              *         SrcRect and the DestRect.   
0885 4747              *
0886 4747              *     2.  Next I get the target rect and clip it myself to the
0887 4747              *         the portrect and store it in SrcRect and DestRect.  I
0888 4747              *         clip it myself here because I have to store it in 
0889 4747              *         the same place as the PortRect.
0890 4747              *
0891 4747              *     3.  Next I get dV and dH off the stack and turn the TargetRect
0892 4747              *         stored at SrcRect and DestRect into the Src and Dest rects
0893 4747              *         needed by StdPixels.
0894 4747              *
0895 4747              *     4.  Next, I set XferMode to indicate Copy.
0896 4747              *
0897 4747              *     5.  Finally, I use the clipRgn and visRgn to create the src
0898 4747              *         and dest region for use with stdpixels.
0899 4747              *
0900 4747              *     6.  After calling StdPixels, I create a region that is the difference
0901 4747              *         of the src and dest regions and erase it.
0902 4747              *
0903 4747              * Warning to all who follow:
0904 4747              *     
0905 4747              *     StdPixels takes advantage of the fact that the DestLocInfo
0906 4747              *     lives on the same part of zeropage as the PortLocInfo does
0907 4747              *     for routines that use the grafport.  Doing this allows me to
0908 4747              *     use GetMinRect to clip the target rect to the intersection
0909 4747              *     of the BoundsRect, PortRect, VisBounds and ClipBounds.
0910 4747              *
0911 4747              *
0912 4747              ****************************************************************
0913 4747                       EXPORT ScrollRect 
0914 4747              ScrollRect PROC 
0915 4747              *              using CoreData
0916 4747              *              using E0Vectors
0917 4747
0918 4747              OrigDirect equ   1                      1
0919 4747              RTL1     equ   OrigDirect+2             3
0920 4747              RTL2     equ   RTL1+3                   7
0921 4747              UpdateRgn equ   RTL2+3                  A
0922 4747              dV       equ   UpdateRgn+4              C
0923 4747              dH       equ   dV+2                     E
0924 4747              TheRectPtr equ   dH+2                   11
0925 4747
0926 4747
0927 4747              ;-----------------------------------------------
0928 4747              ;
0929 4747              ; First we get the inputs from memory to zero
0930 4747              ; page
0931 4747              ;
0932 4747
0933 4747 20 AA 0F              jsr   QDStart
0934 474A
0935 474A A2 00 02 B5           DirtyPort                      ; reset all the dirty DPFlags 
0936 4754
0937 4754 A0 16 00              ldy   #LocSize+8-2             ; move grafport loc info to src and
0938 4757 BB           Loop1    tyx                            ; dest locinfo on zp
0939 4758 B7 24                 lda   [PortRef],y
0940 475A 95 CC                 sta   SrcSCB,x
0941 475C 95 0C                 sta   DestSCB,x
0942 475E 88                    dey   
0943 475F 88                    dey   
0944 4760 10 F5                 bpl   Loop1
0945 4762
0946 4762              ;----------------------------------------------
0947 4762              ; 
0948 4762              ; Now I get the target rect and put it into
0949 4762              ; SrcRect and DestRect after clipping it to
0950 4762              ; the portrect (which is currently stored at
0951 4762              ; SrcRect and DestRect)
0952 4762
0953 4762 8B                    phb                            ; save bank
0954 4763
0955 4763 A3 12                 lda   TheRectPtr+1,s           ; put low word in x
0956 4765 AA                    tax   
0957 4766 A3 13                 lda   TheRectPtr+2,s           ; set bank to bank with target
0958 4768 8B                    phb                            ; rect
0959 4769 83 00                 sta   0,s
0960 476B AB                    plb   
0961 476C
0962 476C BD 00 00              lda   |0,x
0963 476F C5 DC                 cmp   SrcRect
0964 4771 30 04                 bmi   ClipTop
0965 4773 85 DC                 sta   SrcRect
0966 4775 85 1C                 sta   DestRect
0967 4777
0968 4777 BD 02 00     ClipTop  lda   |2,x
0969 477A C5 DE                 cmp   SrcRect+2
0970 477C 30 04                 bmi   ClipLeft
0971 477E 85 DE                 sta   SrcRect+2
0972 4780 85 1E                 sta   DestRect+2
0973 4782
0974 4782 BD 04 00     ClipLeft lda   |4,x
0975 4785 C5 E0                 cmp   SrcRect+4
0976 4787 10 04                 bpl   ClipBot
0977 4789 85 E0                 sta   SrcRect+4
0978 478B 85 20                 sta   DestRect+4
0979 478D
0980 478D BD 06 00     ClipBot  lda   |6,x
0981 4790 C5 E2                 cmp   SrcRect+6
0982 4792 10 04                 bpl   ClipRight
0983 4794 85 E2                 sta   SrcRect+6
0984 4796 85 22                 sta   DestRect+6
0985 4798
0986 4798              ClipRight                               ; 
0987 4798 AB                    plb                            ; restore bank register
0988 4799
0989 4799              ;----------------------------------------------
0990 4799              ;
0991 4799              ; Now I adjust the SrcRect and DestRect
0992 4799              ; accordingly for dH and dV.
0993 4799
0994 4799 A3 0D                 lda   dV,s                     ; get dV
0995 479B 30 0E                 bmi   MoveUp
0996 479D
0997 479D 18                    clc                            ; dv is positive so the top of the
0998 479E 65 1C                 adc   DestRect                 ; dest rect is lower by dV than the
0999 47A0 85 1C                 sta   DestRect                 ; top of the TargetRect
1000 47A2
1001 47A2 A5 E0                 lda   SrcRect+4                ; dV is positive so the bottom
1002 47A4 38                    sec                            ; of SrcRect is dV from the bottom
1003 47A5 E3 0D                 sbc   dV,s                     ; of the target rect
1004 47A7 85 E0                 sta   SrcRect+4
1005 47A9
1006 47A9 80 0C                 bra   AdjustHor
1007 47AB
1008 47AB 18           MoveUp   clc                            ; dV is negative so the top of the
1009 47AC 65 20                 adc   DestRect+4               ; dest rect is the TargetRect, but
1010 47AE 85 20                 sta   DestRect+4               ; the bottom is less than the bottom
1011 47B0              *			; of the targetrect.
1012 47B0              *			; Note that I add Neg to Pos to get
1013 47B0              *			; this to work
1014 47B0
1015 47B0 A5 DC                 lda   SrcRect                  ; dV is negative so the bottom of
1016 47B2 38                    sec                            ; SrcRect is the bottom of the Target
1017 47B3 E3 0D                 sbc   dV,s                     ; Rect, but the top of the SrcRect is
1018 47B5 85 DC                 sta   SrcRect                  ; below the top of TargetRect
1019 47B7
1020 47B7              * Now I do the same shit for the horizontal
1021 47B7 A3 0F        AdjustHor lda   dH,s                    ; get dV
1022 47B9 30 0E                 bmi   MoveLeft
1023 47BB
1024 47BB 18                    clc                            ; dH is positive so the left of the
1025 47BC 65 1E                 adc   DestRect+2               ; dest rect is to rt by dH more than
1026 47BE 85 1E                 sta   DestRect+2               ; left of the TargetRect
1027 47C0
1028 47C0 A5 E2                 lda   SrcRect+6                ; dH is positive so the right
1029 47C2 38                    sec                            ; of SrcRect is dH from the right
1030 47C3 E3 0F                 sbc   dH,s                     ; of the target rect
1031 47C5 85 E2                 sta   SrcRect+6
1032 47C7
1033 47C7 80 0C                 bra   AllAdjusted
1034 47C9
1035 47C9 18           MoveLeft clc                            ; dH is negative so the left of the
1036 47CA 65 22                 adc   DestRect+6               ; dest rect is the TargetRect, but
1037 47CC 85 22                 sta   DestRect+6               ; the right is less than the right
1038 47CE              *			; of the targetrect.
1039 47CE              *			; Note that I add Neg to Pos to get
1040 47CE              *			; this to work
1041 47CE
1042 47CE A5 DE                 lda   SrcRect+2                ; dH is negative so the right of
1043 47D0 38                    sec                            ; SrcRect is the right of the Target
1044 47D1 E3 0F                 sbc   dH,s                     ; Rect, but the left of the SrcRect is
1045 47D3 85 DE                 sta   SrcRect+2                ; to rt the left of TargetRect
1046 47D5
1047 47D5
1048 47D5
1049 47D5
1050 47D5              AllAdjusted                             ; 
1051 47D5
1052 47D5              ;----------------------------------------------
1053 47D5              ;
1054 47D5              ; Set the xfermode and the regions and we're
1055 47D5              ; ready to call StdPixels.
1056 47D5
1057 47D5 64 E4                 stz   XFerMode                 ; set the transfer mode
1058 47D7
1059 47D7              ;-------------------------------------------------
1060 47D7              ;
1061 47D7              ; We create the
1062 47D7              ;     srcRgn := DestRect SECT VisRgn SECT ClipRgn
1063 47D7              ;
1064 47D7              ; But before we do this we must save the srcrect and
1065 47D7              ; destrect since the Rgn calls we are about to make
1066 47D7              ; will destroy this part of zero page.
1067 47D7              ;
1068 47D7 7B                    tdc   
1069 47D8 AA                    tax   
1070 47D9 A0 42 00              ldy   #ZZEndOfSlice-CombinedMask ; num bytes to save
1071 47DC
1072 47DC BF A6 00 00  SaveLoop lda   >CombinedMask,x
1073 47E0 9F 00 02 00           sta   >0+512,x
1074 47E4 E8                    inx   
1075 47E5 E8                    inx   
1076 47E6 88                    dey   
1077 47E7 88                    dey   
1078 47E8 10 F2                 bpl   SaveLoop
1079 47EA
1080 47EA
1081 47EA              ;----------------------------------------------------
1082 47EA              ;
1083 47EA              ; Now I hope it is safe
1084 47EA              ;
1085 47EA              ;
1086 47EA
1087 47EA A5 26 48 A5           PushLong PortRef               ; get this on the stack for now
1088 47F0
1089 47F0 F4 00 00 F4           PushLong #0                    ; get two new region
1090 47F6 A2 04 67 22           _NewRgn 
1091 47FD 90 05                 bcc   Got1Rgn
1092 47FF FA                    plx   
1093 4800 FA                    plx   
1094 4801 4C 46 49              jmp   Error0
1095 4804
1096 4804 F4 00 00 F4  Got1Rgn  PushLong #0 
1097 480A A2 04 67 22           _NewRgn 
1098 4811 90 12                 bcc   Got2Rgn
1099 4813 FA                    plx                            ; get unused space for handle off
1100 4814 FA                    plx                            ; stack
1101 4815 FA                    plx                            ; get handle of rgn 1 off stack into
1102 4816 7A                    ply                            ; x and y
1103 4817 48                    pha                            ; put error code on stack
1104 4818 5A                    phy                            ; put handle of rgn 1 back on stack
1105 4819 DA                    phx   
1106 481A A2 04 68 22           _DisposeRgn                    ; dispose of it
1107 4821 68                    pla                            ; get error back
1108 4822 4C 46 49              jmp   Error0                   ; quit
1109 4825
1110 4825 0B           Got2Rgn  phd                            ; save direct register
1111 4826 3B                    tsc   
1112 4827 5B                    tcd   
1113 4828
1114 4828              xDirect  equ   1                        ; these are equates for this
1115 4828              xSrcRgn  equ   3                        ; temporary zp
1116 4828              xDestRgn equ   7
1117 4828              xPortRef equ   11
1118 4828              StackAddition equ   14                  ; 14 new bytes on stack
1119 4828
1120 4828
1121 4828 D4 05                 pei   xSrcRgn+2                ; SetRectRgn(SrcRgn,left,top,right,bot)
1122 482A D4 03                 pei   xSrcRgn
1123 482C D4 21                 pei   TheRectPtr+StackAddition+2
1124 482E D4 1F                 pei   TheRectPtr+StackAddition
1125 4830 A2 04 6C 22           _RectRgn 
1126 4837 90 03                 bcc   cont1
1127 4839 4C 2D 49              jmp   ErrorD
1128 483C
1129 483C D4 05        cont1    pei   xSrcRgn+2                ; SrcRgn := SrcRgn SECT VisRgn
1130 483E D4 03                 pei   xSrcRgn
1131 4840 A0 1E 00              ldy   #o_VisRgn+2
1132 4843 B7 0B                 lda   [xPortRef],y
1133 4845 48                    pha   
1134 4846 88                    dey   
1135 4847 88                    dey   
1136 4848 B7 0B                 lda   [xPortRef],y
1137 484A 48                    pha   
1138 484B D4 05                 pei   xSrcRgn+2
1139 484D D4 03                 pei   xSrcRgn
1140 484F A2 04 71 22           _SectRgn 
1141 4856 90 03                 bcc   cont2
1142 4858 4C 2D 49              jmp   ErrorD
1143 485B
1144 485B D4 05        cont2    pei   xSrcRgn+2                ; SrcRgn := ClipRgn SECT SrcRgn
1145 485D D4 03                 pei   xSrcRgn
1146 485F A0 1A 00              ldy   #o_ClipRgn+2
1147 4862 B7 0B                 lda   [xPortRef],y
1148 4864 48                    pha   
1149 4865 88                    dey   
1150 4866 88                    dey   
1151 4867 B7 0B                 lda   [xPortRef],y
1152 4869 48                    pha   
1153 486A D4 05                 pei   xSrcRgn+2
1154 486C D4 03                 pei   xSrcRgn
1155 486E A2 04 71 22           _SectRgn 
1156 4875 90 03                 bcc   cont3
1157 4877 4C 2D 49              jmp   ErrorD
1158 487A
1159 487A              ;-------------------------------------------------
1160 487A              ;
1161 487A              ; DestRgn = Offset SrcRgn
1162 487A              ;
1163 487A D4 05        cont3    pei   xSrcRgn+2                ; DestRgn := SrcRgn
1164 487C D4 03                 pei   xSrcRgn
1165 487E D4 09                 pei   xDestRgn+2
1166 4880 D4 07                 pei   xDestRgn
1167 4882 A2 04 69 22           _CopyRgn 
1168 4889 90 03                 bcc   cont4
1169 488B 4C 2D 49              jmp   ErrorD
1170 488E
1171 488E D4 09        cont4    pei   xDestRgn+2
1172 4890 D4 07                 pei   xDestRgn
1173 4892 D4 1D                 pei   dh+StackAddition
1174 4894 D4 1B                 pei   dv+StackAddition
1175 4896 A2 04 6F 22           _OffsetRgn 
1176 489D 90 03                 bcc   cont5
1177 489F 4C 2D 49              jmp   ErrorD
1178 48A2
1179 48A2              ;----------------------------------------------------
1180 48A2              ;
1181 48A2              ; Now I restore my zp and put the src and dest rgn
1182 48A2              ; in RgnHandleA and RgnHandleB
1183 48A2              ;
1184 48A2 2B           cont5    pld                            ; restore direct
1185 48A3 68                    pla   
1186 48A4 85 50                 sta   RgnHandleA               ; this is srcrgn
1187 48A6 68                    pla   
1188 48A7 85 52                 sta   RgnHandleA+2
1189 48A9
1190 48A9 68                    pla   
1191 48AA 85 60                 sta   RgnHandleB
1192 48AC 68                    pla   
1193 48AD 85 62                 sta   RgnHandleB+2
1194 48AF
1195 48AF 68                    pla                            ; pull off port ref
1196 48B0 68                    pla   
1197 48B1
1198 48B1 A9 0C 10              lda   #WideOpen
1199 48B4 85 70                 sta   RgnHandleC
1200 48B6 A9 FE 00              lda   #^WideOpen
1201 48B9 85 72                 sta   RgnHandleC+2
1202 48BB
1203 48BB
1204 48BB
1205 48BB              ;---------------------------------------------------------
1206 48BB              ;
1207 48BB              ; Now I restore SrcRect and DestRect
1208 48BB              ;
1209 48BB 7B                    tdc   
1210 48BC AA                    tax   
1211 48BD A0 42 00              ldy   #ZZEndOfSlice-CombinedMask ; num bytes to restore
1212 48C0
1213 48C0 BF 00 02 00  RepLoop  lda   >0+512,x
1214 48C4 9F A6 00 00           sta   >CombinedMask,x
1215 48C8 E8                    inx   
1216 48C9 E8                    inx   
1217 48CA 88                    dey   
1218 48CB 88                    dey   
1219 48CC 10 F2                 bpl   RepLoop
1220 48CE
1221 48CE              ;----------------------------------------------------------
1222 48CE              ;
1223 48CE              ; Set flag to indicate that we do not clip to port rect
1224 48CE              ;
1225 48CE 64 E6                 stz   ClipToPortToo
1226 48D0
1227 48D0
1228 48D0 22 DC 1F E0           jsl   RgnBlt                   ; comes back with error in a
1229 48D4 B0 70                 bcs   Error0
1230 48D6
1231 48D6              ;----------------------------------------------
1232 48D6              ;
1233 48D6              ; Finally I must create the update region and
1234 48D6              ; erase it.
1235 48D6              ;
1236 48D6              ; Update Region = SrcRgn - DestRgn
1237 48D6              ;
1238 48D6 D4 62                 pei   RgnHandleB+2             ; save these on the stack
1239 48D8 D4 60                 pei   RgnHandleB               ; so can call diff rgn
1240 48DA
1241 48DA D4 52                 pei   RgnHandleA+2
1242 48DC D4 50                 pei   RgnHandleA
1243 48DE
1244 48DE
1245 48DE              yDirect  equ   1
1246 48DE              yHandleA equ   3
1247 48DE              yHandleB equ   7
1248 48DE              yStackSize equ   10
1249 48DE
1250 48DE 0B                    phd   
1251 48DF 3B                    tsc   
1252 48E0 5B                    tcd   
1253 48E1
1254 48E1 D4 05                 pei   yHandleA+2
1255 48E3 D4 03                 pei   yHandleA
1256 48E5
1257 48E5 D4 09                 pei   yHandleB+2
1258 48E7 D4 07                 pei   yHandleB
1259 48E9
1260 48E9 D4 05                 pei   yHandleA+2
1261 48EB D4 03                 pei   yHandleA
1262 48ED
1263 48ED A2 04 73 22           _DiffRgn 
1264 48F4 B0 37                 bcs   ErrorD
1265 48F6
1266 48F6 D4 05                 pei   yHandleA+2
1267 48F8 D4 03                 pei   yHandleA
1268 48FA A2 04 7B 22           _EraseRgn 
1269 4901
1270 4901              ;-------------------------------------------------
1271 4901              ;
1272 4901              ; If the update region passed to this routine is
1273 4901              ; a nil handle then we just free the regions I've
1274 4901              ; created.  If it is not nil, then I copy the update
1275 4901              ; region into it.
1276 4901
1277 4901 A5 13                 lda   UpdateRgn+yStackSize
1278 4903 05 15                 ora   UpdateRgn+yStackSize+2
1279 4905 F0 11                 beq   ReturnNothing
1280 4907
1281 4907 D4 05                 pei   yHandleA+2
1282 4909 D4 03                 pei   yHandleA
1283 490B D4 15                 pei   UpdateRgn+yStackSize+2
1284 490D D4 13                 pei   UpdateRgn+yStackSize
1285 490F A2 04 69 22           _CopyRgn 
1286 4916 B0 15                 bcs   ErrorD
1287 4918
1288 4918              ;-------------------------------------------------
1289 4918              ;
1290 4918              ; Free the regions (and any other political
1291 4918              ; prisoners you can find).
1292 4918
1293 4918
1294 4918 2B           ReturnNothing pld   
1295 4919 A2 04 68 22           _DisposeRgn 
1296 4920 A2 04 68 22           _DisposeRgn 
1297 4927
1298 4927 A0 0C 00              ldy   #12
1299 492A 4C A7 FC              jmp   BusyEC
1300 492D
1301 492D
1302 492D 48           ErrorD   pha   
1303 492E D4 05                 pei   yHandleA+2
1304 4930 D4 03                 pei   yHandleA
1305 4932 A2 04 68 22           _DisposeRgn 
1306 4939 D4 09                 pei   yHandleB+2
1307 493B D4 07                 pei   yHandleB
1308 493D A2 04 68 22           _DisposeRgn 
1309 4944 68                    pla   
1310 4945 2B                    pld   
1311 4946 AA           Error0   tax   
1312 4947 A0 0C 00              ldy   #12
1313 494A 4C AA FC              jmp   BusyErr
1314 494D
1315 494D
1316 494D
1317 494D                       ENDP 
1318 494D              ;                copy pixel.maps/paint.pixels
1319 494D              ****************************************************************
1320 494D              *
1321 494D              * PaintPixels   (PPRecPtr : Ptr);
1322 494D              *
1323 494D              * The PPRec is as follows:
1324 494D              *
1325 494D              *     PtrToSourceLocInfo
1326 494D              *     PtrToDestLocInfo
1327 494D              *     PtrToSourceRect
1328 494D              *     PtrToDestPoint
1329 494D              *     Mode
1330 494D              *     HandleToClipRegion
1331 494D              *
1332 494D              *
1333 494D              * The LocInfo Record Looks Like
1334 494D              *
1335 494D              *     MasterSCB         byte
1336 494D              *     Reserved          byte
1337 494D              *     PtrToPixelMap     long
1338 494D              *     Width             word
1339 494D              *     BoundsRect        rect
1340 494D              *
1341 494D              *
1342 494D              * The Flow of control
1343 494D              *
1344 494D              *     1.  Bring everything to zero page
1345 494D              *     2.  Check to see if the transfer makes sense (SCB's
1346 494D              *         must match).
1347 494D              *     3.  Set up for the slice routines
1348 494D              *     4.  Loop calling the slice routines until all
1349 494D              *         lines are transferred.
1350 494D              *
1351 494D              ****************************************************************
1352 494D                       EXPORT PaintPixels 
1353 494D              PaintPixels PROC 
1354 494D              *              using CoreData
1355 494D
1356 494D              OrigDirect equ   1
1357 494D              RTL1     equ   OrigDirect+2
1358 494D              RTL2     equ   RTL1+3
1359 494D              PPRecPtr equ   RTL2+3
1360 494D
1361 494D
1362 494D              ;-----------------------------------------------
1363 494D              ;
1364 494D              ; First we get the inputs from memory to zero
1365 494D              ; page
1366 494D              ;
1367 494D
1368 494D 20 AA 0F              jsr   QDStart
1369 4950
1370 4950 A2 00 02 B5           DirtyPort                      ; reset dirtyDPFlags here
1371 495A
1372 495A A3 09                 lda   PPRecPtr,s
1373 495C 85 2A                 sta   Temp
1374 495E AA                    tax   
1375 495F A3 0A                 lda   PPRecPtr+1,s
1376 4961 8B                    phb   
1377 4962 48                    pha   
1378 4963 AB                    plb   
1379 4964 AB                    plb   
1380 4965
1381 4965 BD 00 00              lda   |0,x                     ; get pointer to SrcLocInfo
1382 4968 85 2E                 sta   Temp2
1383 496A BD 01 00              lda   |1,x
1384 496D 85 2F                 sta   Temp2+1
1385 496F
1386 496F A0 0E 00              ldy   #LocSize-2               ; move srclocinfo to zp
1387 4972 BB           Loop1    tyx   
1388 4973 B7 2E                 lda   [Temp2],y
1389 4975 95 CC                 sta   SrcSCB,x
1390 4977 88                    dey   
1391 4978 88                    dey   
1392 4979 10 F7                 bpl   Loop1
1393 497B
1394 497B A6 2A                 ldx   Temp                     ; get back pointer to paramlist
1395 497D BD 04 00              lda   |4,x                     ; get pointer to DestLocInfo
1396 4980 85 2E                 sta   Temp2
1397 4982 BD 05 00              lda   |5,x
1398 4985 85 2F                 sta   Temp2+1
1399 4987
1400 4987 A0 0E 00              ldy   #LocSize-2               ; move srclocinfo to zp
1401 498A BB           Loop2    tyx   
1402 498B B7 2E                 lda   [Temp2],y
1403 498D 95 0C                 sta   DestSCB,x
1404 498F 88                    dey   
1405 4990 88                    dey   
1406 4991 10 F7                 bpl   Loop2
1407 4993
1408 4993 A6 2A                 ldx   Temp                     ; get back pointer to paramlist
1409 4995 BD 08 00              lda   |8,x                     ; get pointer to Source Rect
1410 4998 85 2E                 sta   Temp2
1411 499A BD 09 00              lda   |9,x
1412 499D 85 2F                 sta   Temp2+1
1413 499F
1414 499F A0 06 00              ldy   #6                       ; move SourceRect to zp
1415 49A2 BB           Loop3    tyx   
1416 49A3 B7 2E                 lda   [Temp2],y
1417 49A5 95 DC                 sta   SrcRect,x
1418 49A7 88                    dey   
1419 49A8 88                    dey   
1420 49A9 10 F7                 bpl   Loop3
1421 49AB
1422 49AB A6 2A                 ldx   Temp                     ; get back pointer to paramlist
1423 49AD BD 0C 00              lda   |12,x                    ; get pointer to DestLocInfo
1424 49B0 85 2E                 sta   Temp2
1425 49B2 BD 0D 00              lda   |13,x
1426 49B5 85 2F                 sta   Temp2+1
1427 49B7
1428 49B7 A7 2E                 lda   [Temp2]                  ; get the dest point
1429 49B9 85 1C                 sta   DestPoint
1430 49BB A0 02 00              ldy   #2
1431 49BE B7 2E                 lda   [Temp2],y
1432 49C0 85 1E                 sta   DestPoint+2
1433 49C2
1434 49C2 A5 E0                 lda   SrcRect+4                ; stretch the dest point into
1435 49C4 38                    sec                            ; a rect that is the same
1436 49C5 E5 DC                 sbc   SrcRect                  ; size as the SrcRect.
1437 49C7 18                    clc   
1438 49C8 65 1C                 adc   DestPoint
1439 49CA 85 20                 sta   DestPoint+4
1440 49CC
1441 49CC A5 E2                 lda   SrcRect+6
1442 49CE 38                    sec   
1443 49CF E5 DE                 sbc   SrcRect+2
1444 49D1 18                    clc   
1445 49D2 65 1E                 adc   DestPoint+2
1446 49D4 85 22                 sta   DestPoint+6
1447 49D6
1448 49D6 BD 10 00              lda   |16,x                    ; get xfer mode
1449 49D9 85 E4                 sta   XFerMode
1450 49DB
1451 49DB A9 0C 10              lda   #WideOpen                ; put wide open in all the
1452 49DE 85 50                 sta   RgnHandleA               ; region handles.
1453 49E0 85 60                 sta   RgnHandleB
1454 49E2 85 70                 sta   RgnHandleC
1455 49E4 A9 FE 00              lda   #^WideOpen
1456 49E7 85 52                 sta   RgnHandleA+2
1457 49E9 85 62                 sta   RgnHandleB+2
1458 49EB 85 72                 sta   RgnHandleC+2
1459 49ED
1460 49ED BD 12 00              lda   |18,x                    ; now look at the handle
1461 49F0 1D 14 00              ora   |20,x                    ; passed by user
1462 49F3 F0 0A                 beq   UseFake                  ; if it is nil, we are set
1463 49F5 BD 12 00              lda   |18,x                    ; else copy theirs to C
1464 49F8 85 70                 sta   RgnhandleC
1465 49FA BD 14 00              lda   |20,x
1466 49FD 85 72                 sta   RgnHandleC+2
1467 49FF
1468 49FF AB           UseFake  plb                            ; restore the bank register
1469 4A00
1470 4A00              ;----------------------------------------------------------
1471 4A00              ;
1472 4A00              ; Set flag to indicate that we do not clip to port rect
1473 4A00              ;
1474 4A00 64 E6                 stz   ClipToPortToo
1475 4A02
1476 4A02
1477 4A02 22 DE 4A FE           jsl   CallPP                   ; error comes back in a
1478 4A06 AA                    tax   
1479 4A07 A0 04 00              ldy   #4
1480 4A0A 4C AA FC              jmp   BusyErr                  ; (if any)
1481 4A0D
1482 4A0D                       ENDP 
1483 4A0D
1484 4A0D              ;                copy pixel.maps/slice.setup
1485 4A0D              ****************************************************************
1486 4A0D              *
1487 4A0D              * SliceSetup
1488 4A0D              *
1489 4A0D              * This routine sets up the following zp variables:
1490 4A0D              *
1491 4A0D              *      NumSrcWords             NumDestWords
1492 4A0D              *      SrcStartWord            DestStartWord
1493 4A0D              *      SrcFinishWord           DestFinishWord
1494 4A0D              *                              LeftMask
1495 4A0D              *                              RightMask
1496 4A0D              *
1497 4A0D              * NumSrcWords and NumDestWords are mis-named because they really
1498 4A0D              * tell me the number of bytes, not words.
1499 4A0D              *
1500 4A0D              *
1501 4A0D              * It also adjust the boundries for the case where the
1502 4A0D              * number of words in the source and destination are different.
1503 4A0D              *
1504 4A0D              * Consider the three possiblities
1505 4A0D              *
1506 4A0D              * Source                     Dest
1507 4A0D              *
1508 4A0D              * xxxx|abcd|efgh|ijkl|xxxx   xxxx|abcd|efgx|xxxx     S = D
1509 4A0D              * xxxx|abcd|efgh|ijkl|xxxx   xxxa|bcde|fxxx|xxxx     S < D
1510 4A0D              * xxxx|abcd|efgh|ijkl|xxxx   xxxx|xdex|xxxx|xxxx     S > D
1511 4A0D              *
1512 4A0D              * When the source = destination then nothing tricky happens.
1513 4A0D              * When Source < Destination then we pretend to transfer
1514 4A0D              *      one extra word from the source so that the last shift
1515 4A0D              *      out from the source can get to the destination.
1516 4A0D              * When Source > Destination then we start the destinaton
1517 4A0D              *      one word sooner so that the first shift out from the
1518 4A0D              *      source can get to the destination.
1519 4A0D              *
1520 4A0D              ****************************************************************
1521 4A0D
1522 4A0D                       EXPORT iSliceSetUp 
1523 4A0D              iSliceSetUp PROC 
1524 4A0D
1525 4A0D
1526 4A0D              ;-------------------------------------------------
1527 4A0D              ;
1528 4A0D              ; Now we decide which mode were working in so
1529 4A0D              ; that we set up the mode dependent stuff
1530 4A0D              ;
1531 4A0D 24 CB                 bit   SrcSCB-1
1532 4A0F 30 4F                 bmi   Is640
1533 4A11
1534 4A11              ;-------------------------------------------------
1535 4A11              ;
1536 4A11              ; The mode is 320.
1537 4A11              ;
1538 4A11 A5 DE                 lda   SrcRect+2                ; get left edge of source
1539 4A13 38                    sec                            ; change to global coords
1540 4A14 E5 D6                 sbc   SrcBounds+2
1541 4A16 85 42                 sta   HowFarToShift            ; save copy here for later
1542 4A18 4A                    lsr   a                        ; half it so it refers to byte
1543 4A19 29 FE FF              and   #$FFFE                   ; mask so refers to even byte
1544 4A1C 85 AA                 sta   SrcStartWord
1545 4A1E
1546 4A1E A5 E2                 lda   SrcRect+6                ; get right edge of source
1547 4A20 3A                    dec   a                        ; one less so don't write too much
1548 4A21 38                    sec                            ; chage to global coords
1549 4A22 E5 D6                 sbc   SrcBounds+2              ;
1550 4A24 4A                    lsr   a                        ; half it so it refers to byte
1551 4A25 29 FE FF              and   #$FFFE                   ; mask so refers to even byte
1552 4A28 85 AC                 sta   SrcFinishWord
1553 4A2A
1554 4A2A A5 1E                 lda   DestRect+2               ; get dest x
1555 4A2C 38                    sec   
1556 4A2D E5 16                 sbc   DestBounds+2
1557 4A2F AA                    tax                            ; save copy here for later
1558 4A30 4A                    lsr   a                        ; half for byte
1559 4A31 29 FE FF              and   #$FFFE                   ; mask for even byte
1560 4A34 85 B6                 sta   DestStartWord
1561 4A36
1562 4A36 A5 22                 lda   DestRect+6
1563 4A38 3A                    dec   a
1564 4A39 38                    sec   
1565 4A3A E5 16                 sbc   DestBounds+2
1566 4A3C 4A                    lsr   a                        ; half for byte
1567 4A3D 29 FE FF              and   #$FFFE                   ; mask for even byte
1568 4A40 85 B8                 sta   DestFinishWord
1569 4A42
1570 4A42
1571 4A42              ;-------------------------------------------------
1572 4A42              ;
1573 4A42              ; Now I discover which pixel in the word source
1574 4A42              ; and dest are.
1575 4A42              ;
1576 4A42 A5 42                 lda   HowFarToShift            ; this was global first src pixel saved
1577 4A44 29 03 00              and   #3                       ; above
1578 4A47 85 42                 sta   HowFarToShift
1579 4A49 8A                    txa                            ; this was global first dest pixel saved
1580 4A4A 29 03 00              and   #3                       ; above
1581 4A4D C5 42                 cmp   HowFarToShift
1582 4A4F B0 08                 bcs   AllIsWell320
1583 4A51
1584 4A51              ;-------------------------------------------------
1585 4A51              ;
1586 4A51              ; The DestPixel is < SrcPixel.  So we have to
1587 4A51              ; decrement the DestStartWord by 2
1588 4A51              ;
1589 4A51 C6 B6                 dec   DestStartWord
1590 4A53 C6 B6                 dec   DestStartWord
1591 4A55 18                    clc   
1592 4A56 69 04 00              adc   #4
1593 4A59
1594 4A59
1595 4A59              AllIsWell320                            ; 
1596 4A59 38                    sec   
1597 4A5A E5 42                 sbc   HowFarToShift
1598 4A5C
1599 4A5C 0A                    asl   a                        ; make into 0, 4, 8 or 12
1600 4A5D 0A                    asl   a
1601 4A5E
1602 4A5E
1603 4A5E 80 50                 bra   RazzleDazzle
1604 4A60
1605 4A60
1606 4A60              ;-------------------------------------------------
1607 4A60              ;
1608 4A60              ;  The Mode is 640
1609 4A60              ;
1610 4A60 A5 DE        Is640    lda   SrcRect+2                ; get left edge of source
1611 4A62 38                    sec                            ; convert to global coords
1612 4A63 E5 D6                 sbc   SrcBounds+2
1613 4A65 85 42                 sta   HowFarToShift
1614 4A67 4A                    lsr   a                        ; div by 4
1615 4A68 4A                    lsr   a                        ; so it refers to byte
1616 4A69 29 FE FF              and   #$FFFE                   ; mask so it is even byte
1617 4A6C 85 AA                 sta   SrcStartWord
1618 4A6E
1619 4A6E A5 E2                 lda   SrcRect+6                ; get right edge of source
1620 4A70 3A                    dec   a                        ; one less so don't write too much
1621 4A71 38                    sec   
1622 4A72 E5 D6                 sbc   SrcBounds+2
1623 4A74 4A                    lsr   a                        ; div by 4 so it
1624 4A75 4A                    lsr   a                        ; refers to byte
1625 4A76 29 FE FF              and   #$FFFE                   ; mask so it is even byte
1626 4A79 85 AC                 sta   SrcFinishWord
1627 4A7B
1628 4A7B A5 1E                 lda   DestRect+2               ; convert dest to global
1629 4A7D 38                    sec   
1630 4A7E E5 16                 sbc   DestBounds+2
1631 4A80 AA                    tax   
1632 4A81 4A                    lsr   a                        ; div by 4 for
1633 4A82 4A                    lsr   a                        ; byte
1634 4A83 29 FE FF              and   #$FFFE                   ; mask so it is even byte
1635 4A86 85 B6                 sta   DestStartWord
1636 4A88
1637 4A88 A5 22                 lda   DestRect+6
1638 4A8A 3A                    dec   a
1639 4A8B 38                    sec   
1640 4A8C E5 16                 sbc   DestBounds+2
1641 4A8E 4A                    lsr   a                        ; make into number of byte
1642 4A8F 4A                    lsr   a
1643 4A90 29 FE FF              and   #$FFFE                   ; make it an even byte
1644 4A93 85 B8                 sta   DestFinishWord           ; store
1645 4A95
1646 4A95              ;-------------------------------------------------
1647 4A95              ;
1648 4A95              ; Now I discover which pixel in the word source
1649 4A95              ; and dest are.
1650 4A95              ;
1651 4A95 A5 42                 lda   HowFarToShift            ; this was global first src pixel saved
1652 4A97 29 07 00              and   #7                       ; above
1653 4A9A 85 42                 sta   HowFarToShift
1654 4A9C 8A                    txa                            ; this was global first dest pixel saved
1655 4A9D 29 07 00              and   #7                       ; above
1656 4AA0 C5 42                 cmp   HowFarToShift
1657 4AA2 B0 08                 bcs   AllIsWell640
1658 4AA4
1659 4AA4              ;-------------------------------------------------
1660 4AA4              ;
1661 4AA4              ; The DestPixel is < SrcPixel.  So we have to
1662 4AA4              ; decrement the DestStartWord by 2
1663 4AA4              ;
1664 4AA4 C6 B6                 dec   DestStartWord
1665 4AA6 C6 B6                 dec   DestStartWord
1666 4AA8 18                    clc   
1667 4AA9 69 08 00              adc   #8
1668 4AAC
1669 4AAC              AllIsWell640                            ; 
1670 4AAC 38                    sec   
1671 4AAD E5 42                 sbc   HowFarToShift
1672 4AAF
1673 4AAF 0A                    asl   a                        ; make 0, 2, 4, 6, 8 ...
1674 4AB0
1675 4AB0              RazzleDazzle                            ; 
1676 4AB0
1677 4AB0 0A                    asl   a                        ; double it
1678 4AB1 85 42                 sta   HowFarToShift
1679 4AB3
1680 4AB3 A5 B8                 lda   DestFinishWord
1681 4AB5 38                    sec   
1682 4AB6 E5 B6                 sbc   DestStartWord
1683 4AB8 85 BA                 sta   NumDestWords
1684 4ABA
1685 4ABA A5 AC                 lda   SrcFinishWord
1686 4ABC 38                    sec   
1687 4ABD E5 AA                 sbc   SrcStartWord
1688 4ABF 85 AE                 sta   NumSrcWords
1689 4AC1
1690 4AC1 C5 BA                 cmp   NumDestWords
1691 4AC3 F0 18                 beq   AllDone
1692 4AC5
1693 4AC5 90 0E                 bcc   SrcIsLess
1694 4AC7
1695 4AC7              ;-------------------------------------------------
1696 4AC7              ;
1697 4AC7              ; NumSrcWords > NumDestWords.  So make left mask
1698 4AC7              ; zero and decrement the dest start Word by two
1699 4AC7 A9 00 00              lda   #0                       ; left mask must be zero
1700 4ACA 85 A0                 sta   LeftMask
1701 4ACC C6 B6                 dec   DestStartWord
1702 4ACE C6 B6                 dec   DestStartWord
1703 4AD0 E6 BA                 inc   NumDestWords
1704 4AD2 E6 BA                 inc   NumDestWords
1705 4AD4 6B                    rtl   
1706 4AD5
1707 4AD5              ;-------------------------------------------------
1708 4AD5              ;
1709 4AD5              ; NumSrcBytes < NumDestBytes.  So Increment
1710 4AD5              ; the SrcFinishWord by two.
1711 4AD5 E6 AC        SrcIsLess inc   SrcFinishWord
1712 4AD7 E6 AC                 inc   SrcFinishWord
1713 4AD9 E6 AE                 inc   NumSrcWords
1714 4ADB E6 AE                 inc   NumSrcWords
1715 4ADD
1716 4ADD 6B           AllDone  rtl   
1717 4ADE
1718 4ADE                       ENDP 
1719 4ADE
1720 4ADE
1721 4ADE
1722 4ADE
1723 4ADE              ****************************************************************
1724 4ADE              *
1725 4ADE              * CallPP
1726 4ADE              *
1727 4ADE              * Local Routine to call the StdPixel routine (or user routine)
1728 4ADE              *
1729 4ADE              ****************************************************************
1730 4ADE                       EXPORT CallPP 
1731 4ADE              CallPP   PROC 
1732 4ADE              *              using QDProcs
1733 4ADE              *              using E0Vectors
1734 4ADE
1735 4ADE              ;-------------------------------------------------
1736 4ADE              ;
1737 4ADE              ; If the destination loc info is the same as
1738 4ADE              ; the loc info in the current graf port, I must use
1739 4ADE              ; the bottle neck proc in the grafport.
1740 4ADE
1741 4ADE 20 F9 4A              jsr   IsDestPort
1742 4AE1 90 05                 bcc   UseStandard
1743 4AE3
1744 4AE3 20 C3 0F              jsr   TestGPs
1745 4AE6 B0 04                 bcs   NotStandard
1746 4AE8
1747 4AE8 5C 24 1E E0  UseStandard jml   StdPixels
1748 4AEC
1749 4AEC 8B           NotStandard phb                         ; put extra byte on stack
1750 4AED A0 20 00              ldy   #o_stdpixels
1751 4AF0 B7 2A                 lda   [Temp],y                 ; get low word
1752 4AF2 48                    pha                            ; put on stack
1753 4AF3 C8                    iny                            ; get middle and
1754 4AF4 B7 2A                 lda   [Temp],y                 ; high byte
1755 4AF6 83 02                 sta   2,s                      ; overstore middle byte on stack
1756 4AF8 6B                    rtl                            ; go there
1757 4AF9
1758 4AF9                       ENDP 
1759 4AF9
1760 4AF9              ****************************************************************
1761 4AF9              *
1762 4AF9              * IsDestPort
1763 4AF9              *
1764 4AF9              * Compares the destination loc info with the loc info
1765 4AF9              * of the graf port.  if they are the same, then the carry is
1766 4AF9              * set.  Different, carry is clear.
1767 4AF9              *
1768 4AF9              ****************************************************************
1769 4AF9                       EXPORT IsDestPort 
1770 4AF9              IsDestPort PROC 
1771 4AF9              *              using CoreDATA
1772 4AF9
1773 4AF9 A0 0E 00              ldy   #LocSize-2
1774 4AFC BB           Loop     tyx   
1775 4AFD B7 24                 lda   [PortRef],y
1776 4AFF D5 0C                 cmp   DestSCB,x
1777 4B01 D0 06                 bne   No
1778 4B03 88                    dey   
1779 4B04 88                    dey   
1780 4B05 10 F5                 bpl   Loop
1781 4B07
1782 4B07 38                    sec   
1783 4B08 60                    rts   
1784 4B09
1785 4B09 18           No       clc   
1786 4B0A 60                    rts   
1787 4B0B
1788 4B0B                       ENDP 
1789 4B0B
1790 4B0B
1791 4B0B
1792 4B0B
1793 4B0B
1794 4B0B
1795 4B0B                       EXPORT iSetSliceAdr 
1796 4B0B              iSetSliceAdr PROC 
1797 4B0B              *              using E0Vectors
1798 4B0B
1799 4B0B A5 E4                 lda   XFerMode                 ; take the tranfer mode
1800 4B0D 29 7F 00              and   #$7F                     ; mask off not bit
1801 4B10 0A                    asl   a                        ; double
1802 4B11 0A                    asl   a                        ; and double again
1803 4B12 AA                    tax                            ; put in x
1804 4B13
1805 4B13
1806 4B13 A5 42                 lda   HowFarToShift            ; if i don't have to shift at all
1807 4B15 F0 23                 beq   UseFastSlices            ; then I can use the fast slice routines
1808 4B17
1809 4B17 24 CA                 bit   HorBackward              ; oh well so I use the slow ones.
1810 4B19 10 0E                 bpl   SlowHorIsForward
1811 4B1B
1812 4B1B BF AB 4B FE           lda   >BackSliceAdrTable,x
1813 4B1F 8F 00 1E E0           sta   >ToSlice
1814 4B23 BF AD 4B FE           lda   >BackSliceAdrTable+2,x
1815 4B27 80 0C                 bra   StoreIt
1816 4B29
1817 4B29              SlowHorIsForward                        ; 
1818 4B29 BF 9B 4B FE           lda   >SliceAdrTable,x
1819 4B2D 8F 00 1E E0           sta   >ToSlice
1820 4B31 BF 9D 4B FE           lda   >SliceAdrTable+2,x
1821 4B35 8F 02 1E E0  StoreIt  sta   >ToSlice+2
1822 4B39
1823 4B39 6B                    rtl   
1824 4B3A
1825 4B3A              UseFastSlices                           ; 
1826 4B3A
1827 4B3A              ;-------------------------------------------------
1828 4B3A              ;
1829 4B3A              ; I know that I can use the fast routines, can I
1830 4B3A              ; use the really fast copy routine?
1831 4B3A              ;
1832 4B3A A5 E4                 lda   XferMode                 ; transfer mode must be 0!
1833 4B3C D0 1C                 bne   NotSpecial
1834 4B3E
1835 4B3E A5 A4                 lda   NonRectRegions           ; are the clipping regions rectangular?
1836 4B40 D0 18                 bne   NotSpecial
1837 4B42
1838 4B42 A5 BA                 lda   NumDestWords             ; are we copying at least 6 bytes?
1839 4B44 C9 04 00              cmp   #4
1840 4B47 90 11                 bcc   NotSpecial
1841 4B49
1842 4B49 A5 CF                 lda   SrcPixelMapRef+1         ; are source and dest equal to screen?
1843 4B4B C5 0F                 cmp   DestPixelMapRef+1
1844 4B4D D0 0B                 bne   NotSpecial
1845 4B4F 29 FF 0F              and   #$0FFF                   ; strip off the high nibble
1846 4B52 C9 20 01              cmp   #$0120                   ; on either screen???
1847 4B55 D0 03                 bne   NotSpecial
1848 4B57
1849 4B57
1850 4B57 38                    sec                            ; yes Special
1851 4B58 80 01                 bra   GoOn
1852 4B5A
1853 4B5A 18           NotSpecial clc   
1854 4B5B              GoON                                    ; 
1855 4B5B
1856 4B5B 24 CA                 bit   HorBackward              ; forward or back
1857 4B5D 10 1E                 bpl   FastHorIsForward
1858 4B5F
1859 4B5F 90 0E                 bcc   NotSoFastBack
1860 4B61
1861 4B61 AF DB 4B FE           lda   >RealFastBack
1862 4B65 8F 00 1E E0           sta   >ToSlice
1863 4B69 AF DD 4B FE           lda   >RealFastBack+2
1864 4B6D 80 C6                 bra   StoreIt
1865 4B6F
1866 4B6F
1867 4B6F              NotSoFastBack                           ; 
1868 4B6F BF CB 4B FE           lda   >FastBackSliceAdrTable,x
1869 4B73 8F 00 1E E0           sta   >ToSlice
1870 4B77 BF CD 4B FE           lda   >FastBackSliceAdrTable+2,x
1871 4B7B 80 B8                 bra   StoreIt
1872 4B7D
1873 4B7D              FastHorIsForward                        ; 
1874 4B7D 90 0E                 bcc   NotSoFastForward
1875 4B7F
1876 4B7F AF DF 4B FE           lda   >RealFastForward
1877 4B83 8F 00 1E E0           sta   >ToSlice
1878 4B87 AF E1 4B FE           lda   >RealFastForward+2
1879 4B8B 80 A8                 bra   StoreIt
1880 4B8D
1881 4B8D
1882 4B8D              NotSoFastForward                        ; 
1883 4B8D BF BB 4B FE           lda   >FastSliceAdrTable,x
1884 4B91 8F 00 1E E0           sta   >ToSlice
1885 4B95 BF BD 4B FE           lda   >FastSliceAdrTable+2,x
1886 4B99 80 9A                 bra   StoreIt
1887 4B9B
1888 4B9B
1889 4B9B                       ENDP 
1890 4B9B
1891 4B9B
1892 4B9B                       EXPORT SliceAdrTable 
1893 4B9B              SliceAdrTable PROC 
1894 4B9B
1895 4B9B 5C 85 39 FE           jml   FCopySlice
1896 4B9F 5C FD 39 FE           jml   FORSlice
1897 4BA3 5C 70 3A FE           jml   FXORSlice
1898 4BA7 5C E3 3A FE           jml   FBICSlice
1899 4BAB
1900 4BAB                       ENDP 
1901 4BAB
1902 4BAB
1903 4BAB                       EXPORT BackSliceAdrTable 
1904 4BAB              BackSliceAdrTable PROC 
1905 4BAB
1906 4BAB 5C 5C 3B FE           jml   BFCopySlice
1907 4BAF 5C CF 3B FE           jml   BFORSlice
1908 4BB3 5C 3B 3C FE           jml   BFXORSlice
1909 4BB7 5C A7 3C FE           jml   BFBICSlice
1910 4BBB
1911 4BBB                       ENDP 
1912 4BBB
1913 4BBB
1914 4BBB                       EXPORT FastSliceAdrTable 
1915 4BBB              FastSliceAdrTable PROC 
1916 4BBB
1917 4BBB 5C 19 3D FE           jml   fFCopySlice
1918 4BBF 5C 6B 3D FE           jml   fFORSlice
1919 4BC3 5C B8 3D FE           jml   fFXORSlice
1920 4BC7 5C 05 3E FE           jml   fFBICSlice
1921 4BCB
1922 4BCB                       ENDP 
1923 4BCB
1924 4BCB
1925 4BCB                       EXPORT FastBackSliceAdrTable 
1926 4BCB              FastBackSliceAdrTable PROC  
1927 4BCB
1928 4BCB 5C 58 3E FE           jml   fBFCopySlice
1929 4BCF 5C A3 3E FE           jml   fBFORSlice
1930 4BD3 5C E9 3E FE           jml   fBFXORSlice
1931 4BD7 5C 2F 3F FE           jml   fBFBICSlice
1932 4BDB
1933 4BDB                       ENDP 
1934 4BDB
1935 4BDB
1936 4BDB                       EXPORT RealFastBack 
1937 4BDB              RealFastBack PROC 
1938 4BDB 5C D7 41 FE           jml   bRealFastCopy
1939 4BDF                       ENDP 
1940 4BDF
1941 4BDF
1942 4BDF                       EXPORT RealFastForward 
1943 4BDF              RealFastForward PROC 
1944 4BDF 5C 7B 3F FE           jml   fRealFastCopy
1945 4BE3                       ENDP 
1946 4BE3
1947 4BE3                       END   
